<?php
/**
 * Blocksy functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Blocksy
 */

if (version_compare(PHP_VERSION, '5.7.0', '<')) {
	require get_template_directory() . '/inc/php-fallback.php';
	return;
}

require get_template_directory() . '/inc/init.php';


// 
add_action( 'woocommerce_single_product_summary', 'ts_buttons_after_short_description_fixed', 21 );
function ts_buttons_after_short_description_fixed() {
    global $product;

    $product_name  = $product->get_name();
    $product_price = $product->get_price_html();
    $product_url   = get_permalink($product->get_id());

    $whatsapp_number = "91XXXXXXXXXX";
    $call_number     = "91XXXXXXXXXX";

    $message = "Hi, I want to know about this product:\n"
             . "Product Name: $product_name\n"
             . "Price: $product_price\n"
             . "Link: $product_url";

    $encoded = urlencode($message);

    // Add Font Awesome for icons (only once)
    echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">';

    echo '<div style="margin-top:15px;">';

    // WhatsApp button with icon
    echo '<a href="https://wa.me/' . $whatsapp_number . '?text=' . $encoded . '" target="_blank"
             style="background: linear-gradient(45deg, #25D366, #1ebe5d);color:#fff;padding:10px 15px;border-radius:6px;margin-right:10px;display:inline-block;">
             <i class="fab fa-whatsapp" style="margin-right:5px;"></i> WhatsApp
          </a>';

    // Call button with phone icon
    echo '<a href="tel:' . $call_number . '" 
             style="background: linear-gradient(45deg, #007bff, #0056d2);color:#fff;padding:10px 15px;border-radius:6px;display:inline-block;">
             <i class="fas fa-phone" style="margin-right:5px;"></i> Enquiry Call
          </a>';

    echo '</div>';
}

//Mobile 


add_action( 'woocommerce_after_shop_loop_item_title', 'ts_buttons_in_shortcode_products', 15 );
function ts_buttons_in_shortcode_products() {
    global $product;

    $product_name  = $product->get_name();
    $product_price = $product->get_price_html();
    $product_url   = get_permalink($product->get_id());

    $whatsapp_number = "91XXXXXXXXXX"; 
    $call_number     = "91XXXXXXXXXX";

    // WhatsApp Message
    $message = "Hi, I want to know about this product:\n"
             . "Product Name: $product_name\n"
             . "Price: $product_price\n"
             . "Link: $product_url";

    $encoded_message = urlencode($message);

    echo '<div style="margin-top:10px;margin-bottom:10px;">';

    // WhatsApp Button
    echo '<a href="https://wa.me/' . $whatsapp_number . '?text=' . $encoded_message . '" 
             target="_blank"
             style="background: linear-gradient(45deg, #25D366, #1ebe5d);color:#fff;padding:6px 10px;border-radius:5px;margin-right:3px;display:inline-block;font-size:13px;"> <i class="fab fa-whatsapp" style="margin-right:5px;"></i> 
             WhatsApp
          </a>';

    // Call Button
    echo '<a href="tel:' . $call_number . '" 
             style="background: linear-gradient(45deg, #007bff, #0056d2);color:#fff;padding:6px 19px;margin-top: 19px;border-radius:5px;display:inline-block;font-size:13px;">
			     <i class="fas fa-phone" style="margin-right:4px;"></i> 
             Enquiry
          </a>';

    echo '</div>';
}
